pkgname=nodejs
pkgver=20.2.3
pkgdir=$PWD/../build
srcdir=$PWD

# Borrowed from arch linux and maintainer Felix Yan <felixonmars@archlinux.org>
# and contributor Bartłomiej Piotrowski <bpiotrowski@archlinux.org>
# and contributor Thomas Dziedzic < gostrc at gmail >
# and contributor James Campos <james.r.campos@gmail.com>
# and contributor BlackEagle < ike DOT devolder AT gmail DOT com >
# and contributor Dongsheng Cai <dongsheng at moodle dot com>
# and contributor Masutu Subric <masutu.arch at googlemail dot com>
# and contributor TIanyi Cui <tianyicui@gmail.com>

# Allow cc to use gcc
mkdir -p path
ln -s /usr/bin/gcc path/cc
export PATH=$PATH:$PWD/path

patch -d "node-${pkgver%.*}.0" -Rp1 < system-c-ares.patch

cd "node-${pkgver%.*}.0"

./configure \
  --prefix=/usr \
  --with-intl=system-icu \
  --without-npm \
  --shared-openssl \
  --shared-zlib \
  --shared-libuv \
  --experimental-http-parser \
  --shared-nghttp2 \
  --shared-cares
  # --shared-v8
  # --shared-http-parser

make

make test || :

make DESTDIR="$pkgdir" install

install -D -m644 LICENSE \
  "$pkgdir"/usr/share/licenses/nodejs/LICENSE
