/*
 * This file is part of the Zmiy project
 * Copyright (C) 2013-2015 Mateusz Viste
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 */

#include <string.h> /* memset() */

#include "levels.h"


static void gline(struct gamestruct *g, int y, char *s) {
  int x;
  for (x = 0; s[x] != 0; x++) {
    if (s[x] != ' ') {
      g->playfield[y][x] = BLOCK_WALL;
    } else {
      g->playfield[y][x] = BLOCK_EMPTY;
    }
  }
}


static void drawborders(struct gamestruct *g) {
  int i;
  for (i = 0; i < 80; i++) {
    g->playfield[1][i] = BLOCK_WALL;
    g->playfield[49][i] = BLOCK_WALL;
  }
  for (i = 0; i < 50; i++) {
    g->playfield[i][0] = BLOCK_WALL;
    g->playfield[i][79] = BLOCK_WALL;
  }
}


void LoadLevel(struct gamestruct *g, int lev) {
  int x, y, z, t;
  char *s;
  g->snakeposx[0] = 4;
  g->snakeposy[0] = 4;
  g->snakelen[0] = 6;
  g->level = lev;
  g->playfieldwidth = 80;
  g->playfieldheight = 49;
  g->playfieldvoffset = 1;

  g->scrolloffset = 0;

  /* Normalize the level to be in the range 1..16 */
  lev -= 1;
  lev &= 15;
  lev += 1;

  /* clear out the entire field */
  memset(g->playfield, 0, sizeof(g->playfield));
  memset(g->playfieldval, 0, sizeof(g->playfieldval));

  /* draw borders around the playfield */
  drawborders(g);

  switch (lev) {
    case 1: /* LEVEL 1 */
      break;
    case 2: /* LEVEL 2 */
      for (x = 20; x < 60; x++) g->playfield[23][x] = BLOCK_WALL;
      break;
    case 3: /* LEVEL 3 */
      for (y = 12; y < 38; y++) {
        g->playfield[y][21] = BLOCK_WALL;
        g->playfield[y][58] = BLOCK_WALL;
      }
      break;
    case 4: /* LEVEL 4 */
      for (y = 0; y < 50; y += 3) g->playfield[y][39] = BLOCK_WALL;
      break;
    case 5: /* LEVEL 5 */
      for (x = 61; x < 69; x++) {
        g->playfield[1][x] = BLOCK_EMPTY;
        g->playfield[49][x] = BLOCK_EMPTY;
      }
      g->playfield[2][60] = BLOCK_WALL;
      g->playfield[2][69] = BLOCK_WALL;
      g->playfield[48][60] = BLOCK_WALL;
      g->playfield[48][69] = BLOCK_WALL;
      for (x = 0; x < 55; x++) {
        g->playfield[16][x] = BLOCK_WALL;
      }
      for (x = 25; x < 80; x++) {
        g->playfield[33][x] = BLOCK_WALL;
      }
      break;
    case 6: /* LEVEL 6 */
      for (x = 25; x < 55; x++) {
        g->playfield[10][x] = BLOCK_WALL;
        g->playfield[40][x] = BLOCK_WALL;
      }
      for (y = 12; y < 39; y++) {
        g->playfield[y][23] = BLOCK_WALL;
        g->playfield[y][56] = BLOCK_WALL;
      }
      break;
    case 7: /* LEVEL 7 */
      x = 20;
      y = 7;
      z = 40; /* how big our snail starts */
      t = 0; /* the type of line to draw */
      for (; z > 3; z -= 3) {
        if (t == 0) {
            int t1 = x + z;
            for (; x < t1; x++) {
              g->playfield[y][x] = BLOCK_WALL;
            }
          } else if (t == 1) {
            int t1 = y + z;
            for (; y < t1; y++) {
              g->playfield[y][x] = BLOCK_WALL;
            }
          } else if (t == 2) {
            int t1 = x - z;
            for (; x > t1; x--) {
              g->playfield[y][x] = BLOCK_WALL;
            }
          } else if (t == 3) {
            int t1 = y - z;
            for (; y > t1; y--) {
              g->playfield[y][x] = BLOCK_WALL;
            }
        }
        if (t < 3) t += 1; else t = 0;
      }
      break;
    case 8: /* LEVEL 8 */
      for (x = 14; x < 79; x += 13) {
        for (y = 1 + (x & 1); y < 49; y += 2) {
          g->playfield[y][x] = BLOCK_WALL;
        }
      }
      break;
    case 9: /* LEVEL 9 */
      for (x = 8; x < 72; x++) {
        g->playfield[11 + ((x - 10) % 31)][x] = BLOCK_WALL;
      }
      break;
    case 10: /* LEVEL 10 */
      for (x = 1; x < 79; x++) {
        g->playfield[24][x] = BLOCK_WALL;
      }
      for (y = 1; y < 49; y++) {
        g->playfield[y][40] = BLOCK_WALL;
      }
      for (y = 21; y < 24; y++) {
        g->playfield[y][0] = BLOCK_EMPTY;
        g->playfield[y][79] = BLOCK_EMPTY;
      }
      g->playfield[20][1] = BLOCK_WALL;
      g->playfield[20][78] = BLOCK_WALL;
      for (x = 41; x < 44; x++) {
        g->playfield[1][x] = BLOCK_EMPTY;
        g->playfield[49][x] = BLOCK_EMPTY;
      }
      g->playfield[2][44] = BLOCK_WALL;
      g->playfield[48][44] = BLOCK_WALL;
      for (y = 25; y < 28; y++) {
        g->playfield[y][40] = BLOCK_EMPTY;
      }
      g->playfield[28][39] = BLOCK_WALL;
      g->playfield[28][41] = BLOCK_WALL;
      break;
    case 11: /* LEVEL 11 */
      for (z = 55; z > 6; z -= 15) {
        for (x = 40 - (z / 2); x < 40 + (z / 2); x++) {
          g->playfield[25 - (z / 3)][x] = BLOCK_WALL;
          g->playfield[25 + (z / 3)][x] = BLOCK_WALL;
        }
        for (y = 25 - (z / 3); y <= 25 + (z / 3); y++) {
          g->playfield[y][40 - (z / 2)] = BLOCK_WALL;
          g->playfield[y][40 + (z / 2)] = BLOCK_WALL;
        }
      }
      for (y = 2; y < 45; y++) {
        g->playfield[y][15 + y] = BLOCK_EMPTY;
        if (y > 25) {
            g->playfield[y][14 + y] = BLOCK_EMPTY;
          } else {
            g->playfield[y][16 + y] = BLOCK_EMPTY;
        }
      }
      break;
    case 12: /* LEVEL 12 */
      z = 1;
      for (x = 14; x < 70; x += 13) {
        z ^= 1;
        for (y = z * 9; y < (49 - (8 * (z^1))); y++) {
          g->playfield[y][x] = BLOCK_WALL;
        }
      }
      for (y = 2; y < 10; y++) {
        g->playfield[y][0] = BLOCK_EMPTY;
        g->playfield[y][79] = BLOCK_EMPTY;
      }
      break;
    case 13: /* LEVEL 13 */
      for (x = 2; x < 78; x++) {
        g->playfield[1][x] = BLOCK_EMPTY;
        g->playfield[49][x] = BLOCK_EMPTY;
      }
      for (y = 3; y < 48; y++) {
        g->playfield[y][0] = BLOCK_EMPTY;
        g->playfield[y][79] = BLOCK_EMPTY;
      }
      for (y = 9; y < 42; y++) {
        if (y == 25) continue;
        for (x = 8; x < 72; x++) {
          if ((y > 13) && (y < 37) && (x > 24) && (x < 56)) continue;
          g->playfield[y][x] = BLOCK_WALL;
        }
      }
      for (y = 23; y < 28; y++) {
        g->playfield[y][40] = BLOCK_WALL;
      }
      g->playfield[23][39] = BLOCK_WALL;
      g->playfield[27][41] = BLOCK_WALL;
      break;
    case 14: /* LEVEL 14 */
      for (x = 0; x < 80; x++) {
        g->playfield[1][x] = BLOCK_EMPTY;
        g->playfield[49][x] = BLOCK_EMPTY;
      }
      for (y = 1; y < 50; y++) {
        g->playfield[y][0] = BLOCK_EMPTY;
        g->playfield[y][79] = BLOCK_EMPTY;
      }
      for (x = -1; x < 80; x += 4) {
        for (y = 1; y < 50; y += 4) {
          if (((y % 5 == 0) && (x % 3 == 0))) continue;
          if (x + 2 == y) continue;
          if (x + 2 == y + 40) continue;
          if (x >= 0) g->playfield[y][x] = BLOCK_WALL;
          if (x < 79) g->playfield[y][x+1] = BLOCK_WALL;
          if ((x < 79) && (y < 49)) g->playfield[y+1][x+1] = BLOCK_WALL;
          if ((x >= 0) && (y < 49)) g->playfield[y+1][x] = BLOCK_WALL;
        }
      }
      break;
    case 15: /* LEVEL 15 */
      y = 12;
      z = 4;
      s = "  XXXXXXXXX XX       XXXXXXXXXXXX       XXXXXXXXX XX       XXXXXXXXXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = " XXXXXXXXXX XXX     XXXXXXXXXXXXXX     XXXXXXXXXX XXX     XXXXXXXXXXXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXXX        XXXX   XXXX        XXXX   XXXX        XXXX   XXX        XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "  XXXXXXXX XXX     XXX          XXX     XXXXXXXXX XX     XXXXXXXXXXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "  XXXXXXXX XXX     XXX          XXX     XXXXXXXXX XX     XXXXXXXXXXX X";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXX          XXX   XXX          XXX   XXX          XXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "XXXX        XXXX   XXXX        XXXX   XXXX        XXXX   XXX         XXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = " XXX XXXXXXXXXX     XXX XXXXXXXXXX     XXX XXXXXXXXXX     XX XXXXXXXXXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      y++;
      s = "  XX XXXXXXXXX       XX XXXXXXXXX       XX XXXXXXXXX       X XXXXXXXXX";
      for (x = 0; s[x] != 0; x++) if (s[x] != ' ') g->playfield[y][x+z] = BLOCK_WALL;
      break;
    case 16: /* LEVEL 16 */
      for (x = 75; x <= 78; x++) {
        g->playfield[1][x] = BLOCK_EMPTY;
        g->playfield[49][x] = BLOCK_EMPTY;
      }
      y = 6;
      gline(g, y++, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      gline(g, y++, "X                                     X    X                                   X");
      gline(g, y++, "X                                     X    X                                   X");
      gline(g, y++, "X                                     X    X                                   X");
      gline(g, y++, "X                                     X    X                                   X");
      gline(g, y++, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXX    X    X    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX    X");
      gline(g, y++, "X                           X    X    X                                   X    X");
      gline(g, y++, "X                           X    X    X                                   X    X");
      gline(g, y++, "X                           X    X    X                                   X    X");
      gline(g, y++, "X                           X    X    X                                   X    X");
      gline(g, y++, "X    XXXXXXXXXXXXXXXXXXX    X    X    X    XXXXXXXXXXXXXXXXXXXXXXXXXXX    X    X");
      gline(g, y++, "X    X                      X    X    X                              X    X    X");
      gline(g, y++, "X    X                      X    X    X                              X    X    X");
      gline(g, y++, "X    X                      X    X    X                              X    X    X");
      gline(g, y++, "X    X                      X    X    X                              X    X    X");
      gline(g, y++, "X    X                      X    X         XXXXXXXXXXXXXXXXXXXXXXXXXXX    X    X");
      gline(g, y++, "X    X                      X    X         X                                   X");
      gline(g, y++, "X    X                      X    X         X                                   X");
      gline(g, y++, "X    X                      X    X         X                                   X");
      gline(g, y++, "X    X                      X    XXXXXX    X                                   X");
      gline(g, y++, "X    XXXXXXXXXXXXXXXXXXXXXXXX              X    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      gline(g, y++, "                            X              X                                    ");
      gline(g, y++, "                            X              X                                    ");
      gline(g, y++, "                            X              X                                    ");
      gline(g, y++, "                            X              X                                    ");
      gline(g, y++, "XXXXXXXXXXXXXXXXXXXXXXXX    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      gline(g, y++, "X                                X                                             X");
      gline(g, y++, "X                                X                                             X");
      gline(g, y++, "X                                X                                             X");
      gline(g, y++, "X                                X                                             X");
      gline(g, y++, "X                                XXX    XXXXXXX                                X");
      gline(g, y++, "X                                             X                                X");
      gline(g, y++, "X                                             X                                X");
      gline(g, y++, "XXXXXXXXXXXXXXXXXXXXXXXXXXXXX                 X    XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      gline(g, y++, "                            X                                                   ");
      gline(g, y++, "                            X                                                   ");
      gline(g, y++, "                            X                                                   ");
      gline(g, y++, "                            X                                                   ");
      gline(g, y,   "XXXXXXXXXXXXXXXXXXXXXXXX    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
      break;
  }

  /* position the snake on the playfield, and give it some motion */
  g->playfield[g->snakeposy[0]][g->snakeposx[0]] = BLOCK_SNAKE1;
  g->playfieldval[g->snakeposy[0]][g->snakeposx[0]] = 1;
  g->snakedirection[0] = SNAKEDIR_RIGHT;

  /* mark all fields as 'to be refreshed' */
  for (y = g->playfieldvoffset; y < g->playfieldheight + g->playfieldvoffset; y++) {
    for (x = 0 ; x < g->playfieldwidth; x++) {
      g->playfield[y][x] |= BLOCK_REFRESH_FLAG;
    }
  }
}
