/*
 * This file is part of the Zmiy project.
 * Copyright (C) 2013-2015 Mateusz Viste
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 */


#ifndef LEVELS_H_SENTINEL
#define LEVELS_H_SENTINEL

enum snakedirenum {
  SNAKEDIR_UP,
  SNAKEDIR_RIGHT,
  SNAKEDIR_DOWN,
  SNAKEDIR_LEFT
};

enum gameexitstatus {
  EXITGAME_SUCCESS = 0,
  EXITGAME_GAMEOVER = 1,
  EXITGAME_ESCAPE = 2,
  EXITGAME_RESTART = 3
};

#define BLOCK_REFRESH_FLAG 0x10 /* 00010000 */
#define BLOCK_TYPE         0x0F /* 00001111 */

enum blocktypes {
  BLOCK_WALL   = 0x1,          /* 00000001 */
  BLOCK_SNAKE1 = 0x2,          /* 00000010 */
  BLOCK_EMPTY  = 0  /* note that ITEMS are in EMPTY blocks (but with value) */
};

/* this one is a convenience value used for fast check of contiguous blocks
 * that might need to be refreshed, or snake-incremented */
#define DBLREFORSNAKE 0x1212

struct gamestruct {
  unsigned char playfield[50][80];
  unsigned char playfieldval[50][80];
  int snakeposx[2];
  int snakeposy[2];
  int snakelen[2];
  int snakespeed[2];
  unsigned int snakescore[2];
  enum snakedirenum snakedirection[2];
  int playfieldvoffset;
  int playfieldwidth;
  int playfieldheight;
  unsigned short col_bar;
  unsigned short col_snake1;
  unsigned short col_wall;
  unsigned short col_item;
  unsigned short col_msg_good;
  unsigned short col_msg_bad;
  unsigned short col_msg_info;
  int scrolloffset;
  int sleepmeth;
  int screenheight;
  unsigned char level;
  signed char mono;
};

void LoadLevel(struct gamestruct *game, int lev);

#endif
