/***************************************************************************
 * launcher
 * Copyright (C) 2013 Blizzard Entertainment
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***************************************************************************/

#ifndef PATH_INCLUDED
#define PATH_INCLUDED
#pragma once

#include <string>

#include <direct.h>


// All functions in this file work with UTF-8 encoding.

// Returns the path to the currently running program.
std::string app_path();

// Truncates path by removing everything after the last path separator.  If
// path ends with a path separator, this function first removes that character,
// and then truncates.  Returns a reference to the passed-in string.
std::string& remove_last_path_component(std::string& path);


#ifdef _WIN32

// These functions replace the versions provided by Microsoft.  These functions accept
// UTF-8 strings instead of ACP strings.
int win_chdir(const char* path);
#define chdir win_chdir

#endif

#endif
